/*
 
 Copyright (c) 2004 PXI Project Team
 
 Permission is hereby granted, free of charge, to any person obtaining a copy of
 this software and associated documentation files (the "Software"), to deal in the
 Software without restriction, including without limitation the rights to use,
 copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the
 Software, and to permit persons to whom the Software is furnished to do so,
 subject to the following conditions:
 
 The above copyright notice and this permission notice shall be included in all copies
 or substantial portions of the Software.
 
 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 
 */

//  PXIView.m
//  PXIView
//
// last changed by: creysoft

/* Implementation of PXIView

	Right now, all this code does is create a few objects and set some
	properties so we can test the drawing code. Eventually this class
	will manage things like view style, drawing code, etc.

*/

#import "PXIView.h"
#import "PXIPart.h"
#import "PXIIDServer.h"

bool PXISystemStartup = true;

@implementation PXIView

- (id)initWithFrame:(NSRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        // Initialization code here.
		
		//NSWindowController * toolPalette = [[NSWindowController alloc] initWithWindowNibName:@"ToolPalette"];
		
		//PXIEnvironmentTool = PXIToolBrowse;
		//[toolPalette window];
		
		if ( PXISystemStartup )
		{
			PXISystemStartup = false; // System booted. No longer pre-populate PXIViews.
		
			NSObject *d = [[NSObject alloc] init];
			[NSBundle loadNibNamed:@"ToolPalette" owner:self];
		
			PXIIDServer * idserver = [[PXIIDServer alloc] initWithBase:1];
	
			//eventTimer = [NSTimer scheduledTimerWithTimeInterval:0.1 target:self selector:@selector(fireIdleEvents) userInfo:nil repeats:YES];
			cdPartCatalog = [[NSMutableArray alloc] init];
			bgPartCatalog = [[NSMutableArray alloc] init];
		
			[self registerBackgroundPart:
				[[PXIPart alloc]
				initWithFrame:NSMakeRect( 10, 322, 400, 25 )
					   ofType:				PXIPartTypeField
						andProperties:		[NSDictionary dictionaryWithObjectsAndKeys:
								//			VALUE														KEY
											@"LabelField",												PXIKeyPartName,
											PXIAutoGetID(),												PXIKeyPartID,
											PXIBoolYesObject,											PXIKeyLineWrap,
											PXIPartStyleTransparentObject,								PXIKeyPartStyle,
											nil
											]
				]
			];	
		
			[[self getPartFromName:@"LabelField"] setContent:@"Enter a program and click \"Run Program\""];
		
			[self registerCardPart:
				[[PXIPart alloc]
					initWithFrame:NSMakeRect( 370, 320, 100, 22 )
					ofType:				PXIPartTypeButton
					andProperties:		[NSDictionary dictionaryWithObjectsAndKeys:
							//			VALUE														KEY
										@"Run Program",												PXIKeyPartName,
										PXIAutoGetID(),												PXIKeyPartID,
										PXIBoolYesObject,											PXIKeyAutoHilite,
										PXITextAlignCenterObject,									PXIKeyTextAlign,
										PXIPartStyleStandardObject,									PXIKeyPartStyle,
										nil
										]
				]
			];
		
			[self registerCardPart:
				[[PXIPart alloc]
					initWithFrame:NSMakeRect( 10, 10, 460, 200 )
					ofType:				PXIPartTypeField
					andProperties:		[NSDictionary dictionaryWithObjectsAndKeys:
			//			VALUE														KEY
						@"CodeField",												PXIKeyPartName,
						PXIAutoGetID(),												PXIKeyPartID,
						PXIBoolYesObject,											PXIKeyLineWrap,
						PXIPartStyleScrollingObject,								PXIKeyPartStyle,
						@"Monaco",													PXIKeyFontName,
						nil
					]
				]
			];
			
			
			[[self getPartFromName:@"CodeField"] setContent:@"-- Always need a startup function\n\non startup\n\tput \"Hello World\"\nend startup\n"];
			[[self getPartFromName:@"CodeField"] setTextSize:9];
			
			[self registerCardPart:
				[[PXIPart alloc]
					initWithFrame:NSMakeRect( 10, 209, 460, 100 )
					ofType:				PXIPartTypeField
					andProperties:		[NSDictionary dictionaryWithObjectsAndKeys:
			//			VALUE														KEY
						@"ResultField",												PXIKeyPartName,
						PXIAutoGetID(),												PXIKeyPartID,
						PXIBoolYesObject,											PXIKeyLineWrap,
						PXIPartStyleScrollingObject,								PXIKeyPartStyle,
						nil
						]
					]
				];

			[[self getPartFromName:@"ResultField"] setContent:@"Results Appear Here"];
		}
	}
    return self;
}

- (int)registerCardPart:(PXIPart*)whatPart
{
	NSLog( @"Registered card part %@.", [whatPart partName] );
	[cdPartCatalog addObject:whatPart];
	[self addSubview:[whatPart currentview]];
	return [whatPart partID];
}

- (void)unregisterCardPart:(PXIPart*)whatPart
{
	NSLog( @"Should be removing a part here..." );
}

- (int)registerBackgroundPart:(PXIPart*)whatPart
{
	NSLog( @"Registered background part %@.", [whatPart partName] );
	[bgPartCatalog addObject:whatPart];
	[self addSubview:[whatPart currentview]];
	return [whatPart partID];
}

- (void)unregisterBackgroundPart:(PXIPart*)whatPart
{
	NSLog( @"Should be removing a part here..." );
}

- (NSString *)partName {
    return [[partName retain] autorelease];
}

- (void)setPartName:(NSString *)newPartname {
    if (partName != newPartname) {
        [partName release];
        partName = [newPartname copy];
    }
}

- (PXIPart *)getPartFromName:(NSString *)pName
{
	int c;
	for ( c = [cdPartCatalog count] - 1; c >= 0; c -- )
	{
		if( [[[cdPartCatalog objectAtIndex:c] partName] isEqualToString:pName] )
		{
			return [cdPartCatalog objectAtIndex:c];
		}
	}
	for ( c = [bgPartCatalog count] - 1; c >= 0; c -- )
	{
		if( [[[bgPartCatalog objectAtIndex:c] partName] isEqualToString:pName] )
		{
			return [bgPartCatalog objectAtIndex:c];
		}		
	}		
}

- ( void ) fireIdleEvents
{
	int c;
	NSLog( @"idle" );
	for ( c = [cdPartCatalog count] - 1; c >= 0; c -- )
	{
		if ( NSPointInRect( [self convertPoint:[[self window] mouseLocationOutsideOfEventStream] fromView:nil], [[[cdPartCatalog objectAtIndex:c] currentview] frame] ) )
		{
			NSLog( @"%@ : mouseWithin", [[cdPartCatalog objectAtIndex:c] partName] );
			return;
		}
	}
	for ( c = [bgPartCatalog count] - 1; c >= 0; c -- )
	{
		if ( NSPointInRect( [self convertPoint:[[self window] mouseLocationOutsideOfEventStream] fromView:nil], [[[bgPartCatalog objectAtIndex:c] currentview] frame] ) )
		{
			NSLog( @"%@ : mouseWithin", [[bgPartCatalog objectAtIndex:c] partName] );
			return;
		}
	}	
}

- (BOOL)isFlipped
{
	return YES;
}

- (void)mixMaster
{	
	NSString * source;
	NSString * res;
	
	source = [[self getPartFromName:@"CodeField"] content];
	res = [PXICodeMixer doMix:source];
	[[self getPartFromName:@"ResultField"] setContent:res];
}

- (void)drawRect:(NSRect)rect {
    // Drawing code here.
	[[NSColor whiteColor] set]; // or [[NSColor blackColor] set] or whatever...
	//[[NSColor blackColor] set]; // or [[NSColor blackColor] set] or whatever...
	[NSBezierPath fillRect: rect];
}

- (void)dealloc
{
	[eventTimer invalidate];
	[cdPartCatalog release];
	[bgPartCatalog release];
	[super dealloc];
}

@end
